package org.pgusb.usb4allLib;

import java.util.Vector;

import org.pgusb.usb4allAPIWrapper.Usb4allAPIWrapper;
import org.xvolks.jnative.exceptions.NativeException;

import exceptions.Usb4allBoardAlreadyInitializedException;
import exceptions.Usb4allBoardNotInitializedException;
import exceptions.Usb4allDeviceNotInitializedException;
import exceptions.Usb4allDllException;
import exceptions.Usb4allException;

public class Usb4allBoard {
	
	
	//ESTADOS del device
	protected final static int UNINITIALIZED = 0;
	protected final static int INITIALIZED = 1;
	
	//datos de la placa
	private int idBoard;
	private int version;
	private int state;
	//TODO getModules... etc etc
	private Vector<Usb4allDevice> devices;
	private Vector<String> loadedModules;
	
	public Usb4allBoard(){
		devices = new Vector<Usb4allDevice>();
		loadedModules = new Vector<String>();
		state = UNINITIALIZED;
		//TODO sacar este uno, e inicializarlo correctamente
		//ESTE VA A SER EL NRO DE SERIE
		idBoard = 11111111;
	}
	
	public void setIdBoard(int idBoard){
		this.idBoard=idBoard;
	}
	
	public int getIdBoard() {
		return idBoard;
	}

	public String getVersion() throws Usb4allException{
		if (state!=INITIALIZED) throw new Usb4allBoardNotInitializedException();
		return Integer.toString(version);
	}
	
	public void addDevice(Usb4allDevice device) throws Usb4allException{
		if (state!=INITIALIZED) throw new Usb4allBoardNotInitializedException();
		devices.add(device);
	}
	
	public void releaseDevice(Usb4allDevice device) throws Usb4allException{
		if (state!=INITIALIZED) throw new Usb4allBoardNotInitializedException();
		devices.remove(device);
	}
	
	public Vector<String> getLoadedModules(){
		return loadedModules;
	}
	
	public void init() throws Usb4allException{
		//hago un getVersion para ver si la placa esta conectada y guardo la version
		if (state==INITIALIZED) throw new Usb4allBoardAlreadyInitializedException();
		int ret=0xFF;
		try {
			Usb4allAPIWrapper.init();
			ret = Usb4allAPIWrapper.firmwareVersion();
		} catch (NativeException e) {
			throw new Usb4allDllException();
		} catch (IllegalAccessException e) {
			//TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (ret!=0xFF){
			state=INITIALIZED;
			version = ret;
		}
		  
	}
	
	public void release() throws Usb4allException{
		//TODO closear todo.
		if (state!=INITIALIZED) throw new Usb4allBoardNotInitializedException();
		else {
			state = UNINITIALIZED;
		}
	}
		
}
